% finaquant Financial Analytics - www.finaquant.com
% Copyright: Tunc Ali Ktkcoglu  2012, version: 28Mar2012
% Convert returns to assset values
% Cumulate given returns to calculate asset values

function AssetValues = convert_Returns_to_AssetValues(InitialValue, ReturnsVec)
% ReturnsVec: Vector of returns, like [0.02 0.04 -0.01 ...]
% InitialValue: Initial asset value, like 30
% AssetValues: Horizontal vector of asset values

% check if empty vector
if isempty(ReturnsVec)
    error 'Empty vector ReturnsVec'
end
% check the size of vector
[rows,cols] = size(ReturnsVec);
if min(rows,cols) ~= 1
    error 'ReturnsVec must be a 1xN or Nx1 matrix'
end
% return a horizontal vector
if cols == 1
    ReturnsVec = ReturnsVec';
end

% extend vector for initial value
ReturnsVec = [0 ReturnsVec];

% calculate asset values
AssetValues =  InitialValue * cumprod( 1 + ReturnsVec); 
end % function